# 帳票設計書 18-Pending Cluster Tasks Report

## 概要

本ドキュメントは、OpenSearchのCat API「/_cat/pending_tasks」エンドポイントが出力するPending Cluster Tasks Reportの設計仕様を定義する。本帳票はクラスタマネージャノードで保留中（キューイングされている）のクラスタ状態変更タスクの情報をテキストテーブル形式にて出力するものである。

### 本帳票の処理概要

本帳票は、OpenSearchクラスタマネージャのタスクキューに溜まっている保留中のクラスタタスクを一覧化する。クラスタ状態の変更（シャードアロケーション、インデックス作成等）はクラスタマネージャが逐次処理するため、キューの滞留状況はクラスタの健全性を示す重要な指標である。

**業務上の目的・背景**：クラスタマネージャのタスクキューが増大することは、クラスタの応答遅延や状態変更の遅延を意味する。本帳票により保留タスクの数・待機時間・優先度を確認し、クラスタマネージャの負荷状態を診断できる。

**帳票の利用シーン**：クラスタの応答が遅い際の原因調査、クラスタマネージャの負荷監視、大量のインデックス操作実行後のキュー確認に利用される。

**主要な出力内容**：
1. タスク挿入順序（insertOrder）
2. キュー待機時間（timeInQueue）
3. タスク優先度（priority）
4. タスクソース（source）

**帳票の出力タイミング**：ユーザーがREST APIエンドポイント `GET /_cat/pending_tasks` にHTTPリクエストを送信した際にリアルタイムで生成・出力される。

**帳票の利用者**：OpenSearchクラスタ管理者、SRE。

## 帳票種別

一覧表（保留クラスタタスク一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | REST API | `GET /_cat/pending_tasks` | HTTPリクエスト送信 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | text/plain（テキストテーブル）またはJSON/YAML（format指定時） |
| 用紙サイズ | N/A（API応答） |
| 向き | N/A |
| ファイル名 | N/A（HTTPレスポンスボディ） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

テキストテーブル形式で、1行が1保留タスクに対応するシンプルな一覧を出力する。

```
┌────────────────────────────────────────────────────┐
│  ヘッダー部（insertOrder, timeInQueue, priority,    │
│             source）                               │
├────────────────────────────────────────────────────┤
│  明細部（保留タスクごとに1行）                        │
│  例: 1234  5.2s  URGENT  put-mapping [index1]      │
│      1235  3.1s  HIGH    create-index [index2]     │
└────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | insertOrder | タスク挿入順序番号 | PendingClusterTask.getInsertOrder() | 数値（alias: o、右寄せ） |
| 2 | timeInQueue | キュー待機時間 | PendingClusterTask.getTimeInQueue() | TimeValue形式（alias: t、右寄せ） |
| 3 | priority | タスク優先度 | PendingClusterTask.getPriority() | 文字列（alias: p） |
| 4 | source | タスクソース | PendingClusterTask.getSource() | 文字列（alias: s） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | insertOrder | 挿入順序 | PendingClusterTask.getInsertOrder() | 数値 | 可変 |
| 2 | timeInQueue | 待機時間 | PendingClusterTask.getTimeInQueue() | TimeValue | 可変 |
| 3 | priority | 優先度 | PendingClusterTask.getPriority() | IMMEDIATE/URGENT/HIGH/NORMAL/LOW/LANGUID | 可変 |
| 4 | source | ソース | PendingClusterTask.getSource() | 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| local | ローカルノードの情報のみ参照するか | No（デフォルト: false） |
| cluster_manager_timeout | タイムアウト | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | タスク順 | PendingClusterTasksResponseのイテレーション順 |

### 改ページ条件

改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| PendingClusterTask（内部API） | 保留タスク情報取得 | PendingClusterTasksRequest |

### テーブル別参照項目詳細

#### PendingClusterTasksResponse

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| PendingClusterTask.getInsertOrder() | insertOrder | - | 挿入順序番号 |
| PendingClusterTask.getTimeInQueue() | timeInQueue | - | TimeValue形式 |
| PendingClusterTask.getPriority() | priority | - | Priority列挙値 |
| PendingClusterTask.getSource() | source | - | タスクソース文字列 |

## 計算仕様

### 計算項目一覧

本帳票に特別な計算項目は存在しない。取得値をそのまま出力する。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[クライアントからGETリクエスト受信] --> B[RestPendingClusterTasksAction.doCatRequest]
    B --> C[PendingClusterTasksRequest生成]
    C --> D[cluster_manager_timeout, local設定]
    D --> E[NodeClient.admin.cluster.pendingClusterTasks実行]
    E --> F[PendingClusterTasksResponse受信]
    F --> G[buildTable: PendingClusterTaskをループ]
    G --> H[テーブル行追加（insertOrder, timeInQueue, priority, source）]
    H --> I[RestTable.buildResponse]
    I --> J[HTTPレスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 保留タスクがない場合 | 空テーブル | 正常動作（むしろ正常な状態を示す） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 保留タスク数（通常0〜数十個。多い場合は問題兆候） |
| 目標出力時間 | 通常1秒以内 |
| 同時出力数上限 | REST APIスレッドプールに依存 |

## セキュリティ考慮事項

保留タスク情報にはクラスタ操作の詳細が含まれるため、cluster:monitor/task 権限を持つユーザーのみアクセス可能とすべきである。

## 備考

- 保留タスク数が0であることが正常な状態。大量の保留タスクはクラスタマネージャの過負荷を示す
- `master_timeout` パラメータは非推奨
- PendingClusterTasksResponseはIterable実装のためfor-each直接利用可能（行108）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PendingClusterTask.java | `server/src/main/java/org/opensearch/cluster/service/PendingClusterTask.java` | getInsertOrder(), getTimeInQueue(), getPriority(), getSource() |
| 1-2 | PendingClusterTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksResponse.java` | Iterable<PendingClusterTask>実装 |

**読解のコツ**: PendingClusterTasksResponseはIterableを実装しているため、for-eachで直接ループ可能。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` | 帳票メインクラス。119行と非常に短い |

**主要処理フロー**:
1. **行60-62**: routes()で `/_cat/pending_tasks` ルートを定義
2. **行75-91**: doCatRequest()でPendingClusterTasksRequestを発行
3. **行94-103**: getTableWithHeader()で4カラム定義
4. **行105-118**: buildTable()でシンプルなループ

### プログラム呼び出し階層図

```
HTTP GET /_cat/pending_tasks
    |
    +-- AbstractCatAction.prepareRequest()
        |
        +-- RestPendingClusterTasksAction.doCatRequest() [行75]
            |
            +-- PendingClusterTasksRequest [行76]
            +-- NodeClient.admin().cluster().pendingClusterTasks() [行82]
                |
                +-- RestResponseListener.buildResponse() [行86]
                    |
                    +-- buildTable() [行105]
                    |   +-- PendingClusterTask loop [行108]
                    |       +-- table.addCell() x 4 [行110-113]
                    |
                    +-- RestTable.buildResponse() [行88]
```

### データフロー図

```
[入力]                       [処理]                           [出力]

HTTP GET Request      --> RestPendingClusterTasksAction   --> HTTP Response
  /_cat/pending_tasks      |                                  (text/plain
                           +-> PendingClusterTasksRequest      or JSON)
                           +-> PendingClusterTasksResponse
                           |   (Iterable<PendingClusterTask>)
                           +-> buildTable()
                           +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` | ソース | 帳票メインクラス（119行） |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API基底クラス |
| RestTable.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` | ソース | テーブルレスポンス構築 |
| PendingClusterTask.java | `server/src/main/java/org/opensearch/cluster/service/PendingClusterTask.java` | ソース | 保留タスク情報 |
| PendingClusterTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksRequest.java` | ソース | リクエスト |
| PendingClusterTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksResponse.java` | ソース | レスポンス |
| ActionModule.java | `server/src/main/java/org/opensearch/action/ActionModule.java` | ソース | アクション登録 |
